/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IndustrialFanBE;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class IndustrialFanBlock
extends DirectionalKineticBlock
implements IBE<IndustrialFanBE>,
ICogWheel {
    public IndustrialFanBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.blockUpdate((LevelAccessor)level, pos);
    }

    public void updateIndirectNeighbourShapes(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        super.updateIndirectNeighbourShapes(stateIn, worldIn, pos, flags, count);
        this.blockUpdate(worldIn, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.blockUpdate((LevelAccessor)level, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState placedOn = level.getBlockState(pos.relative(face.getOpposite()));
        BlockState placedOnOpposite = level.getBlockState(pos.relative(face));
        if (AbstractChuteBlock.isChute((BlockState)placedOn)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face.getOpposite());
        }
        if (AbstractChuteBlock.isChute((BlockState)placedOnOpposite)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face);
        }
        Direction preferredFacing = this.getPreferredFacing(context);
        if (preferredFacing == null) {
            preferredFacing = context.getNearestLookingDirection();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()));
    }

    protected void blockUpdate(LevelAccessor level, BlockPos pos) {
        if (level instanceof WrappedLevel) {
            return;
        }
        this.notifyFanBlockEntity(level, pos);
        if (level.isClientSide()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, IndustrialFanBE::queueGeneratorUpdate);
    }

    protected void notifyFanBlockEntity(LevelAccessor world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, IndustrialFanBE::blockInFrontChanged);
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        this.blockUpdate((LevelAccessor)context.getLevel(), context.getClickedPos());
        return newState;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public boolean showCapacityWithAnnotation() {
        return true;
    }

    public Class<IndustrialFanBE> getBlockEntityClass() {
        return IndustrialFanBE.class;
    }

    public BlockEntityType<? extends IndustrialFanBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.INDUSTRIAL_FAN.get();
    }
}

